Attribute VB_Name = "modGeneral"
Option Explicit


   Public Const REG_SZ As Long = 1
   Public Const REG_DWORD As Long = 4

   Const STANDARD_RIGHTS_ALL = &H1F0000
   
Const KEY_QUERY_VALUE = &H1
Const KEY_SET_VALUE = &H2
Const KEY_CREATE_SUB_KEY = &H4
Const KEY_ENUMERATE_SUB_KEYS = &H8
Const KEY_NOTIFY = &H10
Const KEY_CREATE_LINK = &H20
Const SYNCHRONIZE = &H100000

   Public Const ERROR_NONE = 0
   Public Const ERROR_BADDB = 1
   Public Const ERROR_BADKEY = 2
   Public Const ERROR_CANTOPEN = 3
   Public Const ERROR_CANTREAD = 4
   Public Const ERROR_CANTWRITE = 5
   Public Const ERROR_OUTOFMEMORY = 6
   Public Const ERROR_ARENA_TRASHED = 7
   Public Const ERROR_ACCESS_DENIED = 8
   Public Const ERROR_INVALID_PARAMETERS = 87
   Public Const ERROR_NO_MORE_ITEMS = 259

   Public Const KEY_ALL_ACCESS = &H3F

   Public Const REG_OPTION_NON_VOLATILE = 0

   
Const HKEY_CLASSES_ROOT = &H80000000
Const HKEY_CURRENT_USER = &H80000001
Const HKEY_LOCAL_MACHINE = &H80000002
Const HKEY_USERS = &H80000003
Const HKEY_PERFORMANCE_DATA = &H80000004
Const HKEY_CURRENT_CONFIG = &H80000005
Const HKEY_DYN_DATA = &H80000006

Declare Function RegQueryValueEx Lib "advapi32.dll" Alias "RegQueryValueExA" (ByVal hKey As Long, ByVal lpValueName As String, ByVal lpReserved As Long, lpType As Long, lpData As Any, lpcbData As Long) As Long         ' Note that if you declare the lpData parameter as String, you must pass it By Value.
Declare Function RegCloseKey Lib "advapi32.dll" _
   (ByVal hKey As Long) As Long
   Declare Function RegCreateKeyEx Lib "advapi32.dll" Alias _
   "RegCreateKeyExA" (ByVal hKey As Long, ByVal lpSubKey As String, _
   ByVal Reserved As Long, ByVal lpClass As String, ByVal dwOptions _
   As Long, ByVal samDesired As Long, ByVal lpSecurityAttributes _
   As Long, phkResult As Long, lpdwDisposition As Long) As Long
   Declare Function RegOpenKeyEx Lib "advapi32.dll" Alias _
   "RegOpenKeyExA" (ByVal hKey As Long, ByVal lpSubKey As String, _
   ByVal ulOptions As Long, ByVal samDesired As Long, phkResult As _
   Long) As Long
   Declare Function RegQueryValueExString Lib "advapi32.dll" Alias _
   "RegQueryValueExA" (ByVal hKey As Long, ByVal lpValueName As _
   String, ByVal lpReserved As Long, lpType As Long, ByVal lpData _
   As String, lpcbData As Long) As Long
   Declare Function RegQueryValueExLong Lib "advapi32.dll" Alias _
   "RegQueryValueExA" (ByVal hKey As Long, ByVal lpValueName As _
   String, ByVal lpReserved As Long, lpType As Long, lpData As _
   Long, lpcbData As Long) As Long
   Declare Function RegQueryValueExNULL Lib "advapi32.dll" Alias _
   "RegQueryValueExA" (ByVal hKey As Long, ByVal lpValueName As _
   String, ByVal lpReserved As Long, lpType As Long, ByVal lpData _
   As Long, lpcbData As Long) As Long
   Declare Function RegSetValueExString Lib "advapi32.dll" Alias _
   "RegSetValueExA" (ByVal hKey As Long, ByVal lpValueName As String, _
   ByVal Reserved As Long, ByVal dwType As Long, ByVal lpValue As _
   String, ByVal cbData As Long) As Long
   Declare Function RegSetValueExLong Lib "advapi32.dll" Alias _
   "RegSetValueExA" (ByVal hKey As Long, ByVal lpValueName As String, _
   ByVal Reserved As Long, ByVal dwType As Long, lpValue As Long, _
   ByVal cbData As Long) As Long



Public Enum RangeUnits
  ruFathoms
  ruFeet
  ruMeters
End Enum

Public Type CommParametersT
  baudRate As Long
  CharacterSize As Integer
  CommPort As Integer
  Parity As Integer
End Type

Public Type GeneralT
  appOrigin As String
  classifier As ClassifierClass
  dBSourcePrefix As String
  developmentDB As DbConnectionClass
  maintenanceMode As Boolean
  Gps As GpsClass
  parametersDb As DbConnectionClass
  pingDB As DbConnectionClass
  propertyList As PropertyListClass
  sonarIF As SonarClass
  sonarParametersName As String
  trackerParameter As GeneralConfigurationClass ' Tracker
End Type

Public Enum TypeOfConfiguration
  unInitializedTC
  trackParametersTC
  trackSeriesTC
End Enum

Public Const MaxArraySize = 65536 * 32 '65536 *2=131072
Public Const NominalSoundSpeed = 1500 ' m/s

Public general As GeneralT


Public Enum optionDP
  echoesInHRP = 0
  totalTracks
  trackingInHRP
End Enum


Public MyStoredError As New MyErrObjectClass
Public isVerbose As Boolean ' flag - silences certain messages...

Public Enum SF2000_ERROR
  ERROR_OFFSET = 1000
  UNKNOWN_ERROR = 3001
  
  ' DB errors 3100-3299
  DELETE_ERROR = 3100
  LOAD_ERROR
  SAVE_ERROR
  PROPERTYLIST_ERROR
  BADCONFIGTYPE_ERROR         ' bad/unhandled configuration type
  CANNOTCREATETABLE_ERROR     ' can't create a missing table found in gen config's db read method
  UNEXPECTED_NULL_ERROR
  ' File Errors 3300-3399
  
  ' Initialization Errors 3400-3499
   
  ' misc 3500-3700
  APPLY_ERROR = 3500
  BADALGORITHM_ERROR
  CLOSE_ERROR
  CTRLCONFIG_ERROR
  FORMREAD_ERROR
  NUMPARAM_ERROR
  SETCONFIGTYPE_ERROR
  VALUE_NOT_SET_ERROR
End Enum

Public Enum TRACKER_STATE
  ENABLE_JPDA = 1
  ENABLE_ALPHABETA = 2
  DISABLE_TRACKING = 3
  SUSPEND_TRACKING = 4
End Enum

Public Enum TRACKER_ALGORITHM
  ALPHABETA = 0
  JPDA = 1
End Enum

Public Sub ChangePingDatabase(ByVal newDB As Boolean, cdlOpen As CommonDialog)

  Dim oldFile As String
  Dim theFile As String

  On Error GoTo oops
  theFile = OpenDB(cdlOpen, dbPing, newDB)
  If theFile <> "" Then
    oldFile = general.pingDB.GetFile
    general.pingDB.dbClose
    general.pingDB.SetFile theFile
    general.pingDB.dbOpen
    If general.pingDB.GetType <> "ping" Then
      general.pingDB.dbClose
      Err.Raise utilGeneralError, , "Not a ping database"
    End If
    general.propertyList.SetProperty "General:PingDB", general.pingDB.GetFile()
  End If
  
  Exit Sub
  
oops:
  ErrorBox boxCaption:="Ping Database Open Failure", _
    bodyPrefix:="Following error occurred; ping database not changed:" & vbCrLf
  general.pingDB.SetFile oldFile
  general.pingDB.dbOpen

End Sub

Private Sub DefaultPropertyForTracker()
  
  On Error GoTo oops:
  ' If the properties needed by the tracker are not present in the P-List this adds the default value
  With general.propertyList
    .SetProperty "Playback:Tracker_Default", .GetProperty("Playback:Tracker_Default", 1)
    .SetProperty "General:Tracker_Parameters", .GetProperty("General:Tracker_Parameters", "default")
    .SetProperty "General:maintenanceMode", general.maintenanceMode
    .SetProperty "General:Tracker_Active", False
  End With
  
  Exit Sub
  
oops:
  ErrorBox
  
End Sub
Public Function OpenDB(cdlOpen As CommonDialog, dbType As DBTypesT, _
                       Optional ByVal newDB As Boolean = False) As String

'Creates a new database file of one of the specified types.
'Copies the template file into the specified file and makes it
'readable.
'
'Returns the new db name if successful, otherwise returns the empty string.

  Dim theFile As String
  Dim templateName As String

  With cdlOpen
  
    Select Case dbType
    
      Case dbPing
        .DefaultExt = "mdb"
        .Filter = "Ping (*.mdb)|*.mdb|All files|*.*"
        templateName = "\dbTemplates\pingData-template.mdb"
        
      Case dbDevelopment
        .DefaultExt = "mdb"
        .Filter = "Development (*.mdb)|*.mdb|All files|*.*"
        templateName = "\dbTemplates\development-template.mdb"
      
      Case dbParameters
        .DefaultExt = "mdb"
        .Filter = "Parameters (*.mdb)|*.mdb|All files|*.*"
        templateName = "\dbTemplates\scifish2000-template.mdb"
    
    End Select
    
    .InitDir = general.appOrigin
    .filename = Format(Now(), "yyyymmddhhNn") & ".mdb"
    .CancelError = True
    .FilterIndex = 1
    
    On Error GoTo cancelled
    
    If newDB Then
      .flags = (cdlOFNOverwritePrompt + cdlOFNPathMustExist)
      .ShowSave
    Else
      .flags = cdlOFNFileMustExist + cdlOFNNoReadOnlyReturn
      .ShowOpen
    End If

    On Error GoTo oops
    
    theFile = .filename
    
    If newDB Then
      FileCopy general.appOrigin & templateName, theFile
      SetAttr theFile, vbNormal
    Else
      ' Consider adding a way to do a cursory check to see if
      ' the file selected is a database and contains the right tables
    End If
  End With
  
  OpenDB = theFile
  Exit Function
  
oops:

  MsgBox "Error #" & Err.number & ": " & Err.description, _
    vbExclamation + vbOKOnly, "Database Creation Error"
  OpenDB = ""

  Exit Function
  
cancelled:

  OpenDB = ""

End Function

Public Sub Main()
  
  Randomize
  frmSplash.Show
  DoEvents
  
  With general
  
     .maintenanceMode = False
           
    .appOrigin = App.Path & "\.."
      
    Set .parametersDb = New DbConnectionClass
    .parametersDb.SetFile .appOrigin & "\data\SciFish2000.mdb"
    Dim ok As Boolean
    ok = FileExists(.parametersDb.GetFile, writable:=True)
    
    If Not ok Then
      MsgBox "The parameters file '" & .parametersDb.GetFile & "'" & vbCrLf & _
           " must exist and be writable for proper program operation." & _
           vbCrLf, _
           vbOKOnly + vbCritical, "Parameter File Anomaly"
      Exit Sub
    End If
    .parametersDb.dbOpen
    
    Set .propertyList = New PropertyListClass
    .propertyList.SetDb .parametersDb
    
    Set .sonarIF = New SonarClass
    
    Set .developmentDB = New DbConnectionClass
    .developmentDB.SetFile .propertyList.GetProperty("General:DevelopmentDB", _
                                                     .appOrigin & "\data\development.mdb")
    If Not FileExists(.developmentDB.GetFile, writable:=True) Then
      .developmentDB.SetFile ""
    Else
      ' JG - Bug 191
      Dim altr_devdb As String
      altr_devdb = "Alter table TmpPingSeries alter column name text(255)"
      .developmentDB.dbOpen
      .developmentDB.Execute altr_devdb
    End If
    
    Set .pingDB = New DbConnectionClass
    .pingDB.SetFile .propertyList.GetProperty("General:PingDB", _
                                              .appOrigin & "\data\pingData.mdb")
    If Not FileExists(.pingDB.GetFile, writable:=True) Then
      .pingDB.SetFile ""
    Else
      .pingDB.dbOpen
    End If
              
  End With
  
  With general
    Set .trackerParameter = New GeneralConfigurationClass
    Set .sonarIF.trx = New TrackerClass
    .trackerParameter.SetConfigType trackParametersTC
  End With
  
  Dim configuration As New SonarConfigurationClass
  Set configuration = New SonarConfigurationClass
  Dim name As String
  name = general.propertyList.GetProperty("General:SonarConfigurationName", "_Default")
  
  On Error GoTo there
  configuration.ReadFromDB name:=name
  
there:
  If Not configuration.IsValid Then
    configuration.ReadFromDB name:="_Default"
  End If
  general.sonarIF.SetSonarConfiguration configuration
    
  Load frmCollection
  general.sonarIF.Construct frmCollection.SonarOCX, frmCollection.tmrSonar
  
    
  Set frmCollection.sonarIF = general.sonarIF
  If general.propertyList.GetProperty("General:Maximized", True) Then
    frmCollection.WindowState = vbMaximized
  Else
    frmCollection.WindowState = vbMaximized
  End If
    
  If Not general.maintenanceMode Then
    general.sonarIF.SetPlaybackMode False
  Else
    general.sonarIF.SetPlaybackMode general.propertyList.GetProperty("General:PlaybackMode", False)
    If general.sonarIF.isPlayback And general.pingDB.GetFile <> "" Then
      With general.propertyList
        Dim pingSeriesName As String
        pingSeriesName = .GetProperty("Playback:PingSeriesName", "")
        If pingSeriesName <> "" Then
          general.sonarIF.SetPingSeriesName pingSeriesName
          general.sonarIF.SetPingSeriesID .GetProperty("Playback:PingSeriesID", "")
          general.sonarIF.SetPingCount .GetProperty("Playback:PingCount", 0)
          general.sonarIF.SetPingInterval .GetProperty("Playback:PingInterval", 0)
          general.sonarIF.SetManualPing .GetProperty("Playback:ManualPing", False)
          general.sonarIF.SetLoopPlayback .GetProperty("Playback:LoopPlayback", False)
        End If
      End With
    End If
  End If
  
  '  Configure and activate the GPS, if appropriate.
  
  Set general.Gps = New GpsClass
  frmCollection.setGps
  general.Gps.SetCommControl frmCollection.comGps
  If general.propertyList.GetProperty("General:UseGps", False) Then
    general.Gps.Activate True, general.propertyList.GetProperty("General:GpsComPort", 1)
  End If

  Sleep (1000)                              ' Show it at least 1 second
  frmSplash.Hide
  frmCollection.Show
  Unload frmSplash
  
  DefaultPropertyForTracker                 ' REB 2002.06.18 initializes property list in db for tracker...
  frmCollection.trackerMnuConfig            ' REB 2002.06.18 reconfigures menues on collection form, if needed.
  isVerbose = True
  
End Sub

   Public Sub QueryValue(sKeyName As String, sValueName As String)
       Dim lRetVal As Long         'result of the API functions
       Dim hKey As Long         'handle of opened key
       Dim vValue As Variant      'setting of queried value

       lRetVal = RegOpenKeyEx(HKEY_LOCAL_MACHINE, sKeyName, 0, _
   KEY_ALL_ACCESS, hKey)
       lRetVal = QueryValueEx(hKey, sValueName, vValue)
       MsgBox vValue
       RegCloseKey (hKey)
   End Sub

   Function QueryValueEx(ByVal lhKey As Long, ByVal szValueName As _
   String, vValue As Variant) As Long
       Dim cch As Long
       Dim lrc As Long
       Dim lType As Long
       Dim lValue As Long
       Dim sValue As String

       On Error GoTo QueryValueExError

       ' Determine the size and type of data to be read
       lrc = RegQueryValueExNULL(lhKey, szValueName, 0&, lType, 0&, cch)
       If lrc <> ERROR_NONE Then Error 5

       Select Case lType
           ' For strings
           Case REG_SZ:
               sValue = String(cch, 0)

   lrc = RegQueryValueExString(lhKey, szValueName, 0&, lType, _
   sValue, cch)
               If lrc = ERROR_NONE Then
                   vValue = Left$(sValue, cch - 1)
               Else
                   vValue = Empty
               End If
           ' For DWORDS
           Case REG_DWORD:
   lrc = RegQueryValueExLong(lhKey, szValueName, 0&, lType, _
   lValue, cch)
               If lrc = ERROR_NONE Then vValue = lValue
           Case Else
               'all other data types not supported
               lrc = -1
       End Select

QueryValueExExit:
       QueryValueEx = lrc
       Exit Function

QueryValueExError:
       Resume QueryValueExExit
   End Function





